<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use Spatie\Permission\Contracts\Permission;
use Spatie\Permission\Models\Permission as ModelsPermission;
use Spatie\Permission\Models\Role;

class RolController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:Ver Rol', ['only' => ['index']]);
        $this->middleware('permission:Crear Rol', ['only' => ['create', 'store']]);
        $this->middleware('permission:Editar Rol', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Eliminar Rol', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::all();
        return view('roles.index', get_defined_vars());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $permisos = ModelsPermission::all();
        $p_roles = [];
        $p_user = [];
        $p_proyecto=[];
        $p_cliente=[];
        $p_lote=[];
        $p_contrato=[];
        $p_recibo=[];
        $p_config= [];
        $p_cotizacion= [];
        $p_estadisticas=[];
        $p_gasto=[];
        $p_ingreso=[];
        $p_marketing=[];

        foreach($permisos as $per){
           if(str_contains($per->name,'Rol')){
            $p_roles[]= $per;
           }
           if(str_contains($per->name,'Usuario')){
            $p_user[]= $per;
           }
           if(str_contains($per->name,'Cliente')){
            $p_cliente[]= $per;
           }
           if(str_contains($per->name,'Proyecto')){
            $p_proyecto[]= $per;
           }
           if(str_contains($per->name,'Lote')){
            $p_lote[]= $per;
           }
           if(str_contains($per->name,'Contrato')){
            $p_contrato[]= $per;
           }
           if(str_contains($per->name,'Recibo')){
            $p_recibo[]= $per;
           }
           if(str_contains($per->name,'Configuracion')){
            $p_config[]= $per;
           }
           if(str_contains($per->name,'Cotizacion')){
            $p_cotizacion[]= $per;
           }
           if(str_contains($per->name,'Estadisticas')){
            $p_estadisticas[]= $per;
           }
           if(str_contains($per->name,'Gasto')){
            $p_gasto[]= $per;
           }
           if(str_contains($per->name,'Ingreso')){
            $p_ingreso[]= $per;
           }
           if(str_contains($per->name,'Marketing')){
            $p_marketing[]= $per;
           }


        }


        return view('roles.create', get_defined_vars());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, ['name' => 'required|unique:roles,name', 'permission' => 'required']);

        $role = Role::create(['name' => $request->input('name')]);
       $role->guard_name = 'web';
        $role->save();

        $role->syncPermissions($request->permission);

        return redirect('roles')->with('msg', 'Rol Creado');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $role = Role::find($id);
        $permisos = ModelsPermission::all();
        $p_roles = [];
        $p_user = [];
        $p_proyecto=[];
        $p_cliente=[];
        $p_lote=[];
        $p_contrato=[];
        $p_recibo=[];
        $p_config= [];
        $p_cotizacion= [];
        $p_estadisticas=[];
        $p_gasto=[];
        $p_ingreso=[];
        $p_marketing=[];

        foreach($permisos as $per){
           if(str_contains($per->name,'Rol')){
            $p_roles[]= $per;
           }
           if(str_contains($per->name,'Usuario')){
            $p_user[]= $per;
           }
           if(str_contains($per->name,'Cliente')){
            $p_cliente[]= $per;
           }
           if(str_contains($per->name,'Proyecto')){
            $p_proyecto[]= $per;
           }
           if(str_contains($per->name,'Lote')){
            $p_lote[]= $per;
           }
           if(str_contains($per->name,'Contrato')){
            $p_contrato[]= $per;
           }
           if(str_contains($per->name,'Recibo')){
            $p_recibo[]= $per;
           }
           if(str_contains($per->name,'Configuracion')){
            $p_config[]= $per;
           }
           if(str_contains($per->name,'Cotizacion')){
            $p_cotizacion[]= $per;
           }
           if(str_contains($per->name,'Estadisticas')){
            $p_estadisticas[]= $per;
           }
           if(str_contains($per->name,'Gasto')){
            $p_gasto[]= $per;
           }
           if(str_contains($per->name,'Ingreso')){
            $p_ingreso[]= $per;
           }
           if(str_contains($per->name,'Marketing')){
            $p_marketing[]= $per;
           }


        }
        $rolePermissions =
            DB::table('role_has_permissions')
            ->where('role_has_permissions.role_id', $id)
            ->pluck('role_has_permissions.permission_id', 'role_has_permissions.permission_id')
            ->all();

        return view('roles.edit', get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, ['name' => 'required|unique:roles,name,' . $id, 'permission' => 'required']);
        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->save();
        $role->syncPermissions($request->input('permission'));
        return redirect('roles')->with('msg', 'Rol Modificado');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        DB::table('roles')->where('id', $id)->delete();
        return redirect()->back()->with('msg', 'Rol Eliminado');
    }
}
