<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role as ModelsRole;
class UsuarioController extends Controller
{
    public function __construct()
    {

        $this->middleware('permission:Ver Usuario', ['only' => ['index']]);
        $this->middleware('permission:Crear Usuario', ['only' => ['create', 'store']]);
        $this->middleware('permission:Editar Usuario', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Eliminar Usuario', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
        return view('usuarios.index', get_defined_vars());
    }

    public function profile()
    {

        return view('usuarios.perfil');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {     $roles = ModelsRole::pluck('name', 'name')->all();
                   return view('usuarios.create', get_defined_vars());
    }


    public function cambiar_avatar(Request $request){
        if ($request->hasFile('avatar')) {
            $request->file('avatar')->storeAs('public/users/' . auth()->user()->email . '/avatar', $request->file('avatar')->getClientOriginalName());
            $input['avatar'] = url('/') . '/storage/users/' . auth()->user()->email . '/avatar/' . ($request->file('avatar')->getClientOriginalName());
            auth()->user()->avatar = $input['avatar'];
            auth()->user()->save();
            return redirect()->back()->with('msg','Avatar Modificado');
        }else{
            return redirect()->back()->with('error','no se ha podido subir el avatar');
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',

        ]);
        $input = $request->all();
        if ($request->hasFile('avatar')) {
            $request->file('avatar')->storeAs('public/users/' . $request->email . '/avatar', $request->file('avatar')->getClientOriginalName());
            $input['avatar'] = url('/') . '/storage/users/' . $request->email . '/avatar/' . ($request->file('avatar')->getClientOriginalName());
        } else {
            $input['avatar'] = asset('/assets/img/fotoperfil.png');
        }
        $input['password'] = Hash::make($request->input('password'));
        $user = User::create($input);

        $user->assignRole('Super Admin');

        return redirect('usuarios')->with('msg', 'Usuario Creado');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
   $roles = ModelsRole::pluck('name', 'name')->all();
               return view('usuarios.edit', get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function cambiar_pass(Request $request)
    {

        if ($request->password == $request->confirm_password) {
            $pass = Hash::make($request->password);
            $user = auth()->user();
            $user->password = $pass;
            $user->save();
            return redirect()->back()->with(['msg' => 'Contraseña modificada']);
        } else {
            return redirect()->back()->with(['error' => 'La contraseñas no coinciden']);
        }
    }

    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $id,


        ]);

        $input = $request->all();
        if (!empty($input['password'])) {
            $input['password'] = Hash::make($input['password']);
        } else {
            $input = Arr::except($input, array('password'));
        }
        if ($request->hasFile('avatar')) {
            $request->file('avatar')->storeAs('public/users/' . $request->email . '/avatar', $request->file('avatar')->getClientOriginalName());
            $input['avatar'] = url('/') . '/storage/users/' . $request->email . '/avatar/' . ($request->file('avatar')->getClientOriginalName());
        }
        $user = User::find($id);
        $user->update($input);
        DB::table('model_has_roles')->where('model_id', $id)->delete();

        $user->assignRole('Super Admin');
        return redirect('usuarios')->with('msg', 'Usuario Modificado');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->back()->with('msg', 'Usuario Eliminado');
    }
}
