<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ReciboPagadoCliente extends Mailable
{
    use Queueable, SerializesModels;
    public $text;
    public $link;
    public $title;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(String $title,String $text,String $link)
    {
        $this->title = $title;
        $this->text = $text;
        $this->link = $link;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
         $title=$this->title;
        $text =$this->text;
        $link =$this->link ;
        return $this->from(env('MAIL_FROM_ADDRESS'))->subject('Pago realizado')->view('mail.recibo_pagado',get_defined_vars());
    }
}
