<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class Marketing extends Notification
{
    use Queueable;
    public $text;
    public $link;
    public $title;
    public  $img;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(String $title,String $text,String $link,String $img)
    {
        $this->title = $title;
        $this->text = $text;
        $this->link = $link;
        $this->img = $img;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {

    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title'=>$this->title,
            'text'=>$this->text,
            'link'=>$this->link,
            'img'=>$this->img,
        ];
    }
}
