<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->text('rcf')->nullable(true);
            $table->text('calle')->nullable(true);
            $table->text('no_ext')->nullable(true);
            $table->text('no_int')->nullable(true);
            $table->text('colonia')->nullable(true);
            $table->text('municipi_delegacion')->nullable(true);
            $table->text('localidad')->nullable(true);
            $table->text('estado')->nullable(true);
            $table->integer('edad')->nullable(true);
            $table->text('ocupacion')->nullable(true);
            $table->text('estado_civil')->nullable(true);
            $table->text('telefono')->nullable(true);
            $table->text('celular')->nullable(true);
            $table->text('numero_alterno')->nullable(true);
            $table->text('nombre_beneficiario')->nullable(true);
            $table->text('telefono_beneficiario')->nullable(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
