<?php

use App\Http\Controllers\AccesoController;
use App\Http\Controllers\ArticuloController;
use App\Http\Controllers\CategoriaController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\ConfiguracionController;
use App\Http\Controllers\CursoController;
use App\Http\Controllers\EstadisticasAsesor;
use App\Http\Controllers\ImprimirController;
use App\Http\Controllers\LibroController;
use App\Http\Controllers\NotiController;
use App\Http\Controllers\NotisMaketingController;
use App\Http\Controllers\NovedadesController;
use App\Http\Controllers\RolController;
use App\Http\Controllers\SoporteController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\VideoArticuloController;
use App\Http\Controllers\VideoController;
use App\Models\Libro;
use Illuminate\Support\Facades\Artisan;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
    Artisan::call('storage:link');
    return "configuracion actualizado";
});
Route::get('/ver-libro/{id}', function ($id) {

    $libros = Libro::all();
    if(Libro::find($id)){
        $inicial = Libro::find($id);
    }else{
        $inicial = $libros->last();
    }

    if(count($libros) > 0){
        return view('front.front',compact('libros','inicial'));
    }else{
        return redirect('/home');
    }

});
Route::get('/', function () {
    $libros = Libro::all();
    $inicial = $libros->last();
    if(count($libros) > 0){
        return view('front.front',compact('libros','inicial'));
    }else{
        return redirect('/home');
    }

})->name('autenticar');

Route::get('/ver/{id}', function ($id) {
    $libro = Libro::find($id);
     $paginas = $libro->paginas();
    return view('front.libro',compact('libro','paginas'));
})->name('ver');
Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::post('/storage-data', [AccesoController::class, 'store']);

Route::group(['middleware' => ['auth:sanctum']], function () {

    //RUTAS DE ROLES
    Route::resource('/roles', RolController::class);
    Route::get('roles-crear', [RolController::class, 'create'])->name('roles-crear');

    //RUTAS DE USUARIO
    Route::resource('/usuarios', UsuarioController::class);
    Route::get('perfil', [UsuarioController::class, 'profile'])->name('usuarios-profile');
    Route::post('usuarios-cambiar-pass', [UsuarioController::class, 'cambiar_pass'])->name('usuarios-cambiar-pass');
    Route::post('usuarios-cambiar-avatar', [UsuarioController::class, 'cambiar_avatar'])->name('usuarios-cambiar-avatar');
    Route::resource('/libro', LibroController::class);
    Route::delete('/libro-delete-img/{id}', [LibroController::class, 'deleteImg']);



});
