<?php $__env->startSection('contenido'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/datetime/1.2.0/css/dataTables.dateTime.min.css">
    <div class="main-content app-content">
        <!-- container -->
        <div class="main-container container-fluid">
            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Libro</span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="<?php echo e(route('libro.index')); ?>">Libros</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Ver Libros</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->
            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row"
                                style="align-items: center;
                            justify-content: center;">
                                <h6 class="main-content-label mb-1">Listado de Libros </h6>
                                <a href="<?php echo e(route('libro.create')); ?>" style="float: right;"><button
                                        class="btn btn-primary">Crear Nuevo</button></a>
                            </div>

                            <div class="table-responsive  export-table">
                                <table id="file-datatable"
                                    class="table table-bordered text-nowrap key-buttons border-bottom">
                                    <thead>
                                        <tr>
                                            <th class="border-bottom-0">id</th>
                                            <th class="border-bottom-0">Nombre</th>
                                            <th class="border-bottom-0">Autor</th>
                                            <th class="border-bottom-0">Resumen</th>
                                            <th class="border-bottom-0">Caratula</th>
                                            <th class="border-bottom-0">Vistas</th>
                                            <th class="border-bottom-0">Descargas</th>
                                            <th class="border-bottom-0">Compartido</th>
                                            <th class="border-bottom-0">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $libros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $libro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($libro->id); ?></td>
                                                <td><?php echo e($libro->nombre); ?></td>
                                                <td><?php echo e($libro->autor); ?></td>
                                                <td><?php echo e($libro->resumen); ?></td>
                                                <td>
                                                    <img src="<?php echo e($libro->caratula); ?>" alt=""
                                                    style="width: 100px;height:100px;border-radius: 100px">
                                                </td>
                                                <td><?php echo e($libro->cant_visitas); ?></td>
                                                <td><?php echo e($libro->cant_descargas); ?></td>
                                                <td><?php echo e($libro->cant_compartir); ?></td>

                                                <td>
                                                        <button title="Eliminar" class="btn btn-danger waves-effect waves-light"
                                                            onclick="deleteConfirm(<?php echo e($libro->id); ?>)"><i
                                                                class="bx bx-trash-alt" style="font-size: 20px"></i></button>
                                                        <a title="Editar" class="btn btn-warning waves-effect waves-light"
                                                            href="<?php echo e(route('libro.edit', $libro->id)); ?>"><i
                                                                class="bx bx-pencil" style="font-size: 20px"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- row -->
        </div>
        <!-- Container closed -->
    </div>
    <script>
        function deleteConfirm(id) {
            Swal.fire({
                title: "Seguro que desea ocultar este Libro?",
                icon: "warning",
                showCancelButton: !0,
                confirmButtonColor: "#34c38f",
                cancelButtonColor: "#f46a6a",
                confirmButtonText: "Si"
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#formDelete").attr('action', '<?php echo e(url('libro/')); ?>' + '/' + id);
                    $("#formDelete").submit();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-independiente'); ?>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/responsive.bootstrap5.min.js')); ?>"></script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.2/moment.min.js"></script>
    <script src="https://cdn.datatables.net/datetime/1.2.0/js/dataTables.dateTime.min.js"></script>
    <script src="https://cdn.datatables.net/plug-ins/1.13.1/api/sum().js"></script>
    <script>


        $(document).ready(function() {


            // DataTables initialisation
            var table = $('#file-datatable').DataTable({
                order: [
                    [0, 'deesc']
                ],
                columnDefs: [{
                    "targets": [0],
                    "visible": false,
                    "searchable": false
                }],
                language: {
                    "decimal": "",
                    "emptyTable": "No hay información",
                    "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                    "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                    "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Mostrar _MENU_ Entradas",
                    "loadingRecords": "Cargando...",
                    "processing": "Procesando...",
                    "search": "Buscar:",
                    "zeroRecords": "Sin resultados encontrados",
                    "paginate": {
                        "first": "Primero",
                        "last": "Ultimo",
                        "next": "Siguiente",
                        "previous": "Anterior"
                    }
                },
                // lengthChange: !1,
                dom: 'Blfrtip',
                buttons: [{
                        extend: 'pdf',
                        text: 'PDF'
                    },
                    {
                        extend: 'excel',
                        text: 'EXCEL'
                    },
                    {
                        extend: 'csv',
                        text: 'CSV'
                    },
                    {
                        extend: 'print',
                        text: 'IMPRIMIR'
                    },

                ],

            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dosbyte1/catalogos.dosbytes-host.com/resources/views/libro/index.blade.php ENDPATH**/ ?>